//
//  NSDecimalNumber+MCAdditions.h
//  MCFoundation
//
//  Created by Eric Hochmeister on 11/15/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#define MCCheckNumberIfNil(X)       if ( X == nil ) { X = [NSNumber numberWithDouble:0.0]; }
#define MCDefaultNumberBehaviour    [NSDecimalNumberHandler decimalNumberHandlerWithRoundingMode:NSRoundBankers \
																						   scale:2              \
																				raiseOnExactness:NO             \
																				 raiseOnOverflow:NO             \
																				raiseOnUnderflow:NO             \
																			 raiseOnDivideByZero:NO]

@interface NSDecimalNumber (MCAdditions)

+ (NSDecimalNumber*)decimalNumberForNumber:(NSNumber*)aNumber;

    /*!
@method     decimalNumberAsPercentForFloat:
     @abstract   takes a float in such as 16% and returns an NSDecimalNumber with a value of 0.16
     @discussion (comprehensive description)
     @param      aPercent - a decimal number as a float, ie. 16.0
     @result     returns an NSDecimalNumber with a value of ie. 0.16
     */
+ (NSDecimalNumber*)decimalNumberAsPercentForDouble:(double)aPercent;

+ (NSDecimalNumber*)decimalNumberAsPercentForNumber:(NSNumber*)aPercent;

@end
